jQuery.fn.latestWorks = function(settings) 
{
	settings = jQuery.extend({
		itemsPerPage : 2,
		animationSpeed : 'slow', /* fast/normal/slow */
		navigation : 'top',  /* top/bottom/both */
		of_label: ' of ', /* The content in the page "1 of 2" */
		previous_title_label: 'Previous page', /* The title of the previous link */
		next_title_label: 'Next page', /* The title of the next link */
		previous_label: 'Previous', /* The content of the previous link */
		next_label: 'Next' /* The content of the next link */
	}, settings);
	return this.each(function(){
		// Global variables needed in multiple functions.	
		var currentPage = 1,
			itemWidth = 0,
			itemMargin = 0,
			itemHeight = 0,
			galleryWidth = 0,
			pageCount = 0,
			animated = false,
			numberOFItems = 0;
			$gallery = $(this);
		
		var latestWorksPrevious = function(caller) {
			// Make sure not to double animate, and not animate of the button is disabled
			if(animated || $(caller).hasClass('disabled')) return;
			animated = true;

			$gallery.find('li:lt('+(currentPage * settings.itemsPerPage)+')').each(function(i){
				$(this).animate({'left': parseFloat($(this).css('left')) + (itemWidth + itemMargin) + itemMargin1 }, settings.animationSpeed, function(){
					animated = false;
				});
			});

			$gallery.find('li:gt('+ ((currentPage * settings.itemsPerPage) - 1) +')').each(function(i){
				$(this).animate({'left': parseFloat($(this).css('left')) + (itemWidth + itemMargin) + itemMargin1 }, settings.animationSpeed);
			});

			currentPage--;

			_displayPaging();
		};

		var latestWorksNext = function(caller) {
			// Make sure not to double animate, and not animate of the button is disabled
			if(animated || $(caller).hasClass('disabled')) return;
			animated = true;

			$gallery.find('li:lt('+(currentPage * settings.itemsPerPage)+')').each(function(i){
				$(this).animate({'left': parseFloat($(this).css('left')) - (itemWidth + itemMargin) - itemMargin1 }, settings.animationSpeed, function(){
					animated = false;
				});
			});

			$gallery.find('li:gt('+ ((currentPage * settings.itemsPerPage) - 1) +')').each(function(i){
				$(this).animate({'left': parseFloat($(this).css('left')) - (itemWidth + itemMargin) - itemMargin1 }, settings.animationSpeed);
			});

			currentPage++;

			_displayPaging();
		};

		var _formatGallery = function() {

			itemWidth = $gallery.find('li:first').outerWidth();

			itemMargin += ($gallery.find('li:first').css('margin-right') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('margin-right'));
			itemMargin += ($gallery.find('li:first').css('margin-left') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('margin-left'));
			itemMargin += ($gallery.find('li:first').css('padding-right') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('padding-right'));
			itemMargin += ($gallery.find('li:first').css('padding-left') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('padding-left'));

			itemMargin1 = ($gallery.find('li:last').css('margin-left') == 'auto') ? 0 : parseFloat($gallery.find('li:last').css('margin-left'));
			//alert(itemMargin1);

			var itemSpacingTopBottom = 0;
				itemSpacingTopBottom += ($gallery.find('li:first').css('margin-top') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('margin-top'));
				itemSpacingTopBottom += ($gallery.find('li:first').css('margin-bottom') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('margin-bottom'));
				itemSpacingTopBottom += ($gallery.find('li:first').css('padding-top') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('padding-top'));
				itemSpacingTopBottom += ($gallery.find('li:first').css('padding-bottom') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('padding-bottom'));


			var itemHeight = -1;
			$gallery.find('li').each(function() {
			    var h = $(this).height(); 
			    itemHeight = h > itemHeight ? h : itemHeight;
			});

			var marginRight = ($gallery.find('li:first').css('margin-right') == 'auto') ? 0 : parseFloat($gallery.find('li:first').css('margin-right'));
			galleryWidth = (itemWidth + itemMargin) * settings.itemsPerPage - marginRight; // We don't want the margin of the last item, that's why we remove it.
            
			$gallery.css({
				'width': '100%',
				'height': itemHeight,
				'overflow': 'hidden',
				'position': 'relative',
				'clear': 'left'
			});
			$gallery.find('li').each(function(i){
				if($(window).width() < 767)
				{
					itemMargin1=0;
				}

				if(i==0)
				{
					$(this).css({
						'position':'absolute',
						'top':0,
						'left':0,
						'overflow':'hidden'
					});
				}
				else
				{
					$(this).css({
						'position':'absolute',
						'top':0,
						'left':(i * (itemWidth + itemMargin1))-itemMargin1,
						'overflow':'hidden'
					});
				}
			});
			
			$gallery.wrap('<div class="latestWorksContainer"></div>');
		};

		var _displayPaging = function() {
			$cg = $gallery.parents('div.latestWorksContainer:first'); // The containing gallery

			$cg.find('ul.pg_paging span.current').text(currentPage);
			$cg.find('ul.pg_paging span.total').text(pageCount);

			// Make sur all the links are enabled
			$cg.find('ul.pg_paging li a').removeClass('disabled');

			// Display the proper nav
			if(currentPage == 1){
				// Hide the previous button
				$cg.find('ul.pg_paging li.pg_previous a').addClass('disabled');
				//alert("first");
			} else if(currentPage == pageCount) {
				// Hide the next button
				$cg.find('ul.pg_paging li.pg_next a').addClass('disabled');
				//alert("last");
			};
		};

		var _applyNav = function() {
			var template = '';
				template +='<ul id="main_paging" class="pg_paging">';
				template += '<li class="pg_previous transition"><a href="#" class="transition" title="'+settings.previous_title_label+'"><i class="icon-caret-left"></i></a></li>';
				//template += '<li><span class="current">1</span>'+settings.of_label+'<span class="total">1</span></li>';
				template += '<li class="pg_next transition"><a href="#" class="transition" title="'+settings.next_title_label+'"><i class="icon-caret-right"></i></a></li>';
				template += '</ul>';

			switch(settings.navigation){
				case 'top':
					$gallery.before(template);
					break;
				case 'bottom':
					$gallery.after(template);
					break;
				case 'both':
					$gallery.before(template);
					$gallery.after(template);
					break;
			};

			// Adjust the nav to the gallery width
			var $theNav = $gallery.parent('div.latestWorksContainer:first').find('ul.pg_paging');
			galleryBorderWidth = parseFloat($theNav.css('border-left-width')) + parseFloat($theNav.css('border-right-width'));
			$theNav.width();
			$theNav.each(function(){
				$(this).find('li:eq(1)').width(galleryWidth - galleryBorderWidth - parseFloat($(this).parent().find('ul.prettyNavigation li:first').width()) - parseFloat($(this).parent().find('ul.prettyNavigation li:last').width()));
			});

			// Apply the functions to the buttons
			$theNav.find('li.pg_previous a').click(function(){
				latestWorksPrevious(this);
				return false;
			});

			$theNav.find('li.pg_next a').click(function(){
				latestWorksNext(this);
				return false;
			});
		};

		if($(this).find('li').size() > 0) 
		{	

			if($(window).width() < 767)
			{
				pageCount = Math.ceil($(this).find('li').size());
				//alert(pageCount);
			}
			else if($(window).width() > 767 && $(window).width() < 979){
				settings.itemsPerPage = 2;
				pageCount = Math.ceil($(this).find('li').size() - (settings.itemsPerPage- 1));
				//alert(pageCount);
			}
			else if($(window).width() > 979)
			{
				//gjeje display items sipas span
				if($(this).find('li').attr('class') == 'span1')
				{
					settings.itemsPerPage = 12;
				}
				else if($(this).find('li').attr('class') == 'span2')
				{
					settings.itemsPerPage = 6;
				}
				else if($(this).find('li').attr('class') == 'span3')
				{
					settings.itemsPerPage = 4;
				}
				else if($(this).find('li').attr('class') == 'span4')
				{
					settings.itemsPerPage = 3;
				}
				else if($(this).find('li').attr('class') == 'span6')
				{
					settings.itemsPerPage = 2;
				}
				else if($(this).find('li').attr('class') == 'span12')
				{
					settings.itemsPerPage = 1;
				}
				pageCount = Math.ceil($(this).find('li').size() - (settings.itemsPerPage- 1));
			}

			
			
			
			// Format the gallery properly
			_formatGallery();
			
			// Build and display the nav
			_applyNav();
			
			// Display the proper paging
			_displayPaging(this);
			currentPage = 1;
			
			if(pageCount <= 1)
			{
				//alert(pageCount);
				$("#main_paging").css('display', 'none');
			}
			window.addEventListener("resize", function() {
				$gallery.css("visibility", "hidden");
				//alert("test");
				currentPage = 1;

				$cg = $gallery.parents('div.latestWorksContainer:first'); // The containing gallery
				// Make sur all the links are enabled
				$cg.find('ul.pg_paging li a').removeClass('disabled');
				$cg.find('ul.pg_paging li.pg_previous a').addClass('disabled');

				if($(window).width() < 767)
				{
					pageCount = Math.ceil($gallery.find('li').size());
					//alert("page count:" + pageCount + " current page:" + currentPage + " itemsPerPage:" + settings.itemsPerPage);
					//alert("mobile");
				}
				else if($(window).width() > 767 && $(window).width() < 979){
					settings.itemsPerPage = 2;
					pageCount = Math.ceil($gallery.find('li').size() - (settings.itemsPerPage - 1));
					//alert("page count:" + pageCount + " current page:" + currentPage + " itemsPerPage:" + settings.itemsPerPage);
					//alert("tablet");
				}
				else if($(window).width() > 979)
				{
					//gjeje display items sipas span
					if($gallery.find('li').attr('class') == 'span1')
					{
						settings.itemsPerPage = 12;
					}
					else if($gallery.find('li').attr('class') == 'span2')
					{
						settings.itemsPerPage = 6;
					}
					else if($gallery.find('li').attr('class') == 'span3')
					{
						settings.itemsPerPage = 4;
					}
					else if($gallery.find('li').attr('class') == 'span4')
					{
						settings.itemsPerPage = 3;
					}
					else if($gallery.find('li').attr('class') == 'span6')
					{
						settings.itemsPerPage = 2;
					}
					else if($gallery.find('li').attr('class') == 'span12')
					{
						settings.itemsPerPage = 1;
					}
					pageCount = Math.ceil($gallery.find('li').size() - (settings.itemsPerPage - 1));
					//alert("page count:" + pageCount + " current page:" + currentPage + " itemsPerPage:" + settings.itemsPerPage);
					//alert("desktop");
				}

				itemWidth = $gallery.find('li:first').outerWidth();

				var itemHeight = -1;
				$gallery.find('li').each(function() {
				    var h = $(this).height(); 
				    itemHeight = h > itemHeight ? h : itemHeight;
				});

				itemMargin1 = ($gallery.find('li:last').css('margin-left') == 'auto') ? 0 : parseFloat($gallery.find('li:last').css('margin-left'));

				$gallery.css({
					'width': '100%',
					'height': itemHeight,
					'overflow': 'hidden',
					'position': 'relative',
					'clear': 'left'
				});



				$gallery.find('li').each(function(i){
					//$(this).css('width',"100%");
					if($(window).width() < 767)
					{
						itemMargin1=0;
					}

					if(i==0)
					{
						$(this).css({
							'position':'absolute',
							'top':0,
							'left':0,
							'overflow':'hidden'
						});
					}
					else
					{
						$(this).css({
							'position':'absolute',
							'top':0,
							'left':(i * (itemWidth + itemMargin1))-itemMargin1,
							'overflow':'hidden'
						});
					}
				});
				$gallery.css("visibility", "visible");
			}, false);
		};
	});
};